/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap2;

import com.floragunn.dlic.auth.ldap.LdapUser;
import com.floragunn.dlic.auth.ldap.util.Utils;
import com.floragunn.dlic.auth.ldap2.LDAPConnectionManager;
import com.floragunn.dlic.auth.ldap2.ParametrizedFilter;
import com.floragunn.dlic.util.SettingsBasedSSLConfigurator;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.legacy.LegacyAuthorizationBackend;
import com.floragunn.searchguard.legacy.LegacyComponentFactory;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.HashMultimap;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.io.IOException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;

public class LDAPAuthorizationBackend2
implements LegacyAuthorizationBackend,
AutoCloseable {
    static final int ZERO_PLACEHOLDER = 0;
    static final int ONE_PLACEHOLDER = 1;
    static final int TWO_PLACEHOLDER = 2;
    static final String DEFAULT_ROLEBASE = "";
    static final String DEFAULT_ROLESEARCH = "(member={0})";
    static final String DEFAULT_ROLENAME = "name";
    static final String DEFAULT_USERROLENAME = "memberOf";
    protected static final Logger log = LogManager.getLogger(LDAPAuthorizationBackend2.class);
    private final Settings settings;
    private final List<Map.Entry<String, Settings>> roleBaseSettings;
    private final LDAPConnectionManager lcm;
    public static TypedComponent.Info<LegacyAuthorizationBackend> INFO = new TypedComponent.Info<LegacyAuthorizationBackend>(){

        public Class<LegacyAuthorizationBackend> getType() {
            return LegacyAuthorizationBackend.class;
        }

        public String getName() {
            return "ldap2";
        }

        public TypedComponent.Factory<LegacyAuthorizationBackend> getFactory() {
            return LegacyComponentFactory.adapt(LDAPAuthorizationBackend2::new);
        }
    };

    public LDAPAuthorizationBackend2(Settings settings, Path configPath) {
        this.settings = settings;
        this.roleBaseSettings = LDAPAuthorizationBackend2.getRoleSearchSettings(settings);
        try {
            this.lcm = new LDAPConnectionManager(settings, configPath);
        }
        catch (SettingsBasedSSLConfigurator.SSLConfigException | LDAPException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Map.Entry<String, Settings>> getRoleSearchSettings(Settings settings) {
        Map groupedSettings = settings.getGroups("roles", true);
        if (!groupedSettings.isEmpty()) {
            return Utils.getOrderedBaseSettings(groupedSettings);
        }
        return LDAPAuthorizationBackend2.convertOldStyleSettingsToNewStyle(settings);
    }

    private static List<Map.Entry<String, Settings>> convertOldStyleSettingsToNewStyle(Settings settings) {
        HashMap<String, Settings> result = new HashMap<String, Settings>(1);
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("base", settings.get("rolebase", DEFAULT_ROLEBASE));
        settingsBuilder.put("search", settings.get("rolesearch", DEFAULT_ROLESEARCH));
        result.put("convertedOldStyleSettings", settingsBuilder.build());
        return Collections.singletonList(result.entrySet().iterator().next());
    }

    public void fillRoles(final User user, final AuthCredentials optionalAuthCreds) throws ElasticsearchSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    LDAPAuthorizationBackend2.this.fillRoles0(user, optionalAuthCreds);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof ElasticsearchSecurityException) {
                throw (ElasticsearchSecurityException)e.getException();
            }
            if (e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new RuntimeException(e.getException());
        }
    }

    private void fillRoles0(User user, AuthCredentials optionalAuthCreds) throws ElasticsearchSecurityException {
        List skipUsers;
        String originalUserName;
        String authenticatedUser;
        if (user == null) {
            return;
        }
        SearchResultEntry entry = null;
        String dn = null;
        if (user instanceof LdapUser && ((LdapUser)user).getUserEntry() != null && ((LdapUser)user).getUserEntry().getUbEntry() != null) {
            entry = ((LdapUser)user).getUserEntry().getUbEntry();
            dn = entry.getDN();
            authenticatedUser = entry.getDN();
            originalUserName = ((LdapUser)user).getOriginalUsername();
        } else {
            authenticatedUser = user.getName();
            originalUserName = user.getName();
        }
        boolean rolesearchEnabled = this.settings.getAsBoolean("rolesearch_enabled", Boolean.valueOf(true));
        if (log.isDebugEnabled()) {
            log.debug("Try to get roles for {}", (Object)authenticatedUser);
        }
        if (log.isTraceEnabled()) {
            log.trace("user class: {}", user.getClass());
            log.trace("authenticatedUser: {}", (Object)authenticatedUser);
            log.trace("originalUserName: {}", (Object)originalUserName);
            log.trace("entry: {}", (Object)String.valueOf(entry));
            log.trace("dn: {}", (Object)dn);
        }
        if (!(skipUsers = this.settings.getAsList("skip_users", Collections.emptyList())).isEmpty() && (WildcardMatcher.matchAny((Collection)skipUsers, (String)originalUserName) || WildcardMatcher.matchAny((Collection)skipUsers, (String)authenticatedUser))) {
            if (log.isDebugEnabled()) {
                log.debug("Skipped search roles of user {}/{}", (Object)authenticatedUser, (Object)originalUserName);
            }
            return;
        }
        try (LDAPConnection con = this.lcm.getConnection();){
            Attribute userRoleAttribute;
            if (entry == null || dn == null) {
                if (this.isValidDn(authenticatedUser)) {
                    if (log.isTraceEnabled()) {
                        log.trace("{} is a valid DN", (Object)authenticatedUser);
                    }
                    if ((entry = this.lcm.lookup(con, authenticatedUser)) == null) {
                        throw new ElasticsearchSecurityException("No user '" + authenticatedUser + "' found", new Object[0]);
                    }
                } else {
                    entry = this.lcm.exists(con, user.getName());
                    if (log.isTraceEnabled()) {
                        log.trace("{} is not a valid DN and was resolved to {}", (Object)authenticatedUser, (Object)entry);
                    }
                    if (entry == null || entry.getDN() == null) {
                        throw new ElasticsearchSecurityException("No user " + authenticatedUser + " found", new Object[0]);
                    }
                }
                dn = entry.getDN();
                if (log.isTraceEnabled()) {
                    log.trace("User found with DN {}", (Object)dn);
                }
            }
            HashSet<LdapName> ldapRoles = new HashSet<LdapName>(150);
            HashSet<String> nonLdapRoles = new HashSet<String>(150);
            HashMultimap resultRoleSearchBaseKeys = HashMultimap.create();
            String userRoleNames = this.settings.get("userrolename", DEFAULT_USERROLENAME);
            if (log.isTraceEnabled()) {
                log.trace("raw userRoleName(s): {}", (Object)userRoleNames);
            }
            for (String userRoleName : userRoleNames.split(",")) {
                String roleName = userRoleName.trim();
                if (entry.getAttribute(roleName) == null) continue;
                String[] userRoles = entry.getAttribute(roleName).getValues();
                for (String possibleRoleDN : userRoles) {
                    if (this.isValidDn(possibleRoleDN)) {
                        LdapName ldapName = new LdapName(possibleRoleDN);
                        ldapRoles.add(ldapName);
                        resultRoleSearchBaseKeys.putAll((Object)ldapName, this.roleBaseSettings);
                        continue;
                    }
                    nonLdapRoles.add(possibleRoleDN);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("User attr. ldap roles count: {}", (Object)ldapRoles.size());
                log.trace("User attr. ldap roles {}", ldapRoles);
                log.trace("User attr. non-ldap roles count: {}", (Object)nonLdapRoles.size());
                log.trace("User attr. non-ldap roles {}", nonLdapRoles);
            }
            String roleName = this.settings.get("rolename", DEFAULT_ROLENAME);
            if (log.isTraceEnabled()) {
                log.trace("roleName: {}", (Object)roleName);
            }
            String userRoleAttributeName = this.settings.get("userroleattribute", null);
            if (log.isTraceEnabled()) {
                log.trace("userRoleAttribute: {}", (Object)userRoleAttributeName);
                log.trace("rolesearch: {}", (Object)this.settings.get("rolesearch", DEFAULT_ROLESEARCH));
            }
            String userRoleAttributeValue = null;
            Attribute attribute = userRoleAttribute = userRoleAttributeName == null ? null : entry.getAttribute(userRoleAttributeName);
            if (userRoleAttribute != null) {
                userRoleAttributeValue = Utils.getSingleStringValue(userRoleAttribute);
            }
            if (rolesearchEnabled) {
                String escapedDn = dn;
                for (Map.Entry entry2 : this.roleBaseSettings) {
                    Settings roleSearchSettings = (Settings)entry2.getValue();
                    ParametrizedFilter pf = new ParametrizedFilter(roleSearchSettings.get("search", DEFAULT_ROLESEARCH));
                    pf.setParameter(0, escapedDn);
                    pf.setParameter(1, originalUserName);
                    pf.setParameter(2, userRoleAttributeValue == null ? null : userRoleAttributeValue);
                    List<SearchResultEntry> rolesResult = this.lcm.search(con, roleSearchSettings.get("base", DEFAULT_ROLEBASE), SearchScope.SUB, pf);
                    if (log.isTraceEnabled()) {
                        log.trace("Results for LDAP group search for " + escapedDn + " in base " + (String)entry2.getKey() + ":\n" + rolesResult);
                    }
                    if (rolesResult == null || rolesResult.isEmpty()) continue;
                    for (SearchResultEntry searchResultEntry : rolesResult) {
                        LdapName ldapName = new LdapName(searchResultEntry.getDN());
                        ldapRoles.add(ldapName);
                        resultRoleSearchBaseKeys.put((Object)ldapName, (Object)entry2);
                    }
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("roles count total {}", (Object)ldapRoles.size());
            }
            if (this.settings.getAsBoolean("resolve_nested_roles", Boolean.valueOf(false)).booleanValue()) {
                List nestedRoleFilter = this.settings.getAsList("nested_role_filter", Collections.emptyList());
                if (log.isTraceEnabled()) {
                    log.trace("Evaluate nested roles");
                }
                HashSet<LdapName> nestedReturn = new HashSet<LdapName>(ldapRoles);
                for (LdapName roleLdapName : ldapRoles) {
                    Set nameRoleSearchBaseKeys = resultRoleSearchBaseKeys.get((Object)roleLdapName);
                    if (nameRoleSearchBaseKeys == null) {
                        log.error("Could not find roleSearchBaseKeys for " + roleLdapName + "; existing: " + resultRoleSearchBaseKeys);
                        continue;
                    }
                    Set<LdapName> nestedRoles = this.resolveNestedRoles(roleLdapName, con, userRoleNames, 0, rolesearchEnabled, nameRoleSearchBaseKeys, nestedRoleFilter);
                    if (log.isTraceEnabled()) {
                        log.trace("{} nested roles for {}", (Object)nestedRoles.size(), (Object)roleLdapName);
                    }
                    nestedReturn.addAll(nestedRoles);
                }
                for (LdapName roleLdapName : nestedReturn) {
                    String role = this.getRoleFromEntry(con, roleLdapName, roleName);
                    if (!Strings.isNullOrEmpty((String)role)) {
                        user.addRole(role);
                        continue;
                    }
                    log.warn("No or empty attribute '{}' for entry {}", (Object)roleName, (Object)roleLdapName);
                }
            } else {
                for (LdapName roleLdapName : ldapRoles) {
                    String string = this.getRoleFromEntry(con, roleLdapName, roleName);
                    if (!Strings.isNullOrEmpty((String)string)) {
                        user.addRole(string);
                        continue;
                    }
                    log.warn("No or empty attribute '{}' for entry {}", (Object)roleName, (Object)roleLdapName);
                }
            }
            for (String nonLdapRoleName : nonLdapRoles) {
                user.addRole(nonLdapRoleName);
            }
            if (log.isDebugEnabled()) {
                log.debug("Roles for {} -> {}", (Object)user.getName(), (Object)user.getRoles());
            }
            if (log.isTraceEnabled()) {
                log.trace("returned user: {}", (Object)user);
            }
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Unable to fill user roles due to ", (Throwable)e);
            }
            throw new ElasticsearchSecurityException(e.toString(), e, new Object[0]);
        }
    }

    protected Set<LdapName> resolveNestedRoles(LdapName roleDn, LDAPConnection con, String userRoleName, int depth, boolean rolesearchEnabled, Set<Map.Entry<String, Settings>> roleSearchBaseSettingsSet, List<String> roleFilter) throws ElasticsearchSecurityException, LDAPException {
        if (!roleFilter.isEmpty() && WildcardMatcher.matchAny(roleFilter, (String)roleDn.toString())) {
            if (log.isTraceEnabled()) {
                log.trace("Filter nested role {}", (Object)roleDn);
            }
            return Collections.emptySet();
        }
        ++depth;
        HashSet<LdapName> result = new HashSet<LdapName>(20);
        HashMultimap resultRoleSearchBaseKeys = HashMultimap.create();
        SearchResultEntry e0 = this.lcm.lookup(con, roleDn.toString());
        if (e0.getAttribute(userRoleName) != null) {
            String[] userRoles = e0.getAttribute(userRoleName).getValues();
            for (String possibleRoleDN : userRoles) {
                if (this.isValidDn(possibleRoleDN)) {
                    try {
                        LdapName ldapName = new LdapName(possibleRoleDN);
                        result.add(ldapName);
                        resultRoleSearchBaseKeys.putAll((Object)ldapName, this.roleBaseSettings);
                    }
                    catch (InvalidNameException ldapName) {}
                    continue;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug("Cannot add {} as a role because its not a valid dn", (Object)possibleRoleDN);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("result nested attr count for depth {} : {}", (Object)depth, (Object)result.size());
        }
        if (rolesearchEnabled) {
            String escapedDn = roleDn.toString();
            for (Map.Entry entry : Utils.getOrderedBaseSettings(roleSearchBaseSettingsSet)) {
                Settings roleSearchSettings = (Settings)entry.getValue();
                ParametrizedFilter pf = new ParametrizedFilter(roleSearchSettings.get("search", DEFAULT_ROLESEARCH));
                pf.setParameter(0, escapedDn);
                pf.setParameter(1, escapedDn);
                List<SearchResultEntry> foundEntries = this.lcm.search(con, roleSearchSettings.get("base", DEFAULT_ROLEBASE), SearchScope.SUB, pf);
                if (log.isTraceEnabled()) {
                    log.trace("Results for LDAP group search for " + escapedDn + " in base " + (String)entry.getKey() + ":\n" + foundEntries);
                }
                if (foundEntries == null) continue;
                for (SearchResultEntry entry2 : foundEntries) {
                    try {
                        LdapName dn = new LdapName(entry2.getDN());
                        result.add(dn);
                        resultRoleSearchBaseKeys.put((Object)dn, (Object)entry);
                    }
                    catch (InvalidNameException e) {
                        throw new LDAPException(ResultCode.INVALID_DN_SYNTAX, (Throwable)e);
                    }
                }
            }
        }
        int maxDepth = 30;
        try {
            maxDepth = this.settings.getAsInt("max_nested_depth", Integer.valueOf(30));
        }
        catch (Exception e) {
            log.error("max_nested_depth is not parseable: " + e, (Throwable)e);
        }
        if (depth < maxDepth) {
            for (LdapName ldapName : new HashSet<LdapName>(result)) {
                Set nameRoleSearchBaseKeys = resultRoleSearchBaseKeys.get((Object)ldapName);
                if (nameRoleSearchBaseKeys == null) {
                    log.error("Could not find roleSearchBaseKeys for " + ldapName + "; existing: " + resultRoleSearchBaseKeys);
                    continue;
                }
                Set<LdapName> in = this.resolveNestedRoles(ldapName, con, userRoleName, depth, rolesearchEnabled, nameRoleSearchBaseKeys, roleFilter);
                result.addAll(in);
            }
        }
        return result;
    }

    public String getType() {
        return "ldap";
    }

    private boolean isValidDn(String dn) {
        if (Strings.isNullOrEmpty((String)dn)) {
            return false;
        }
        try {
            new LdapName(dn);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private String getRoleFromEntry(LDAPConnection con, LdapName ldapName, String role) {
        if (ldapName == null || Strings.isNullOrEmpty((String)role)) {
            return null;
        }
        if ("dn".equalsIgnoreCase(role)) {
            return ldapName.toString();
        }
        try {
            Attribute roleAttribute;
            SearchResultEntry roleEntry = this.lcm.lookup(con, ldapName.toString());
            if (roleEntry != null && (roleAttribute = roleEntry.getAttribute(role)) != null) {
                return Utils.getSingleStringValue(roleAttribute);
            }
        }
        catch (LDAPException e) {
            log.error("Unable to handle role {} because of ", (Object)ldapName, (Object)e.toString(), (Object)e);
        }
        return null;
    }

    @Override
    public void close() {
        if (this.lcm != null) {
            try {
                this.lcm.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

